<?php

namespace Drupal\wse_parallel\Parallel;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Interface for resolving live workspace revision IDs.
 */
interface LiveRevisionResolverInterface {

  /**
   * Gets the live workspace revision ID for an entity.
   *
   * This method temporarily switches to the live workspace context,
   * loads the entity, and retrieves its revision ID, then restores
   * the original workspace context.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to get the live revision ID for.
   *
   * @return int|null
   *   The live revision ID, or NULL if the entity doesn't exist in live yet.
   */
  public function getLiveRevisionId(ContentEntityInterface $entity): ?int;

}
