<?php

namespace Drupal\wse_parallel\Publish;

use Drupal\workspaces\WorkspaceInterface;

/**
 * Interface for the publish logger service.
 */
interface PublishLoggerInterface {

  /**
   * Capture pre-publish "from" revision IDs for all items in this publish.
   *
   * Stores a short-lived record keyed by workspace ID.
   *
   * @param \Drupal\workspaces\WorkspaceInterface $workspace
   *   The workspace being published.
   * @param array $publishedRevisionIds
   *   Map of entity type ID to revision ID => entity ID pairs.
   *   Format: [$entity_type_id => [$to_revision_id => $entity_id, ...], ...].
   */
  public function recordPrePublish(WorkspaceInterface $workspace, array $publishedRevisionIds): void;

  /**
   * Finalize the publish record by writing rows with from/to pairs.
   *
   * Falls back to recomputing "from" if no pre state exists (best-effort).
   *
   * @param \Drupal\workspaces\WorkspaceInterface $workspace
   *   The workspace being published.
   * @param array $publishedRevisionIds
   *   Map of entity type ID to revision ID => entity ID pairs.
   *   Format: [$entity_type_id => [$to_revision_id => $entity_id, ...], ...].
   */
  public function recordPostPublish(WorkspaceInterface $workspace, array $publishedRevisionIds): void;

}
