<?php

namespace Drupal\wse_parallel\Snapshot;

use Drupal\workspaces\WorkspaceInterface;

/**
 * Interface for the snapshot manager service.
 */
interface SnapshotManagerInterface {

  /**
   * Creates a snapshot for a workspace at publish time.
   *
   * @param \Drupal\workspaces\WorkspaceInterface $workspace
   *   The workspace being published.
   * @param array $published_revision_ids
   *   Array of published revisions keyed by entity type.
   *   Format: [entity_type => [revision_id => entity_id]]
   */
  public function createSnapshot(WorkspaceInterface $workspace, array $published_revision_ids): void;

  /**
   * Deletes a snapshot for a workspace.
   *
   * This should be called when a workspace is reverted so the snapshot
   * can be recreated.
   *
   * @param string $workspace_id
   *   The workspace ID.
   */
  public function deleteSnapshot(string $workspace_id): void;

  /**
   * Gets the snapshot data for a workspace.
   *
   * @param string $workspace_id
   *   The workspace ID.
   *
   * @return array|null
   *   The snapshot data array, or NULL if no snapshot exists.
   *   Format: [entity_type => [entity_id => revision_id]]
   */
  public function getSnapshot(string $workspace_id): ?array;

}
