<?php

namespace Drupal\wse_parallel\WorkspaceState;

/**
 * Service to track workspace state context for historic entity viewing.
 *
 * This service maintains state about which workspace's published state
 * we want to view, allowing entities to be loaded as they were at the
 * time of that workspace's publication.
 */
class WorkspaceStateContext implements WorkspaceStateContextInterface {

  /**
   * The current workspace state context.
   *
   * @var array|null
   */
  protected ?array $context = NULL;

  /**
   * {@inheritdoc}
   */
  public function setContext(string $workspace_id, int $published_timestamp): void {
    $this->context = [
      'workspace_id' => $workspace_id,
      'published_timestamp' => $published_timestamp,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function clearContext(): void {
    $this->context = NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function hasContext(): bool {
    return $this->context !== NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getContext(): ?array {
    return $this->context;
  }

}
