<?php

namespace Drupal\wse_parallel\WorkspaceState;

/**
 * Interface for the workspace state context service.
 *
 * This service tracks when we want to view entities as they were at the time
 * a specific workspace was published, allowing historic state reconstruction.
 */
interface WorkspaceStateContextInterface {

  /**
   * Sets the workspace state context for historic viewing.
   *
   * @param string $workspace_id
   *   The workspace ID to view the state of.
   * @param int $published_timestamp
   *   The timestamp when this workspace was published.
   */
  public function setContext(string $workspace_id, int $published_timestamp): void;

  /**
   * Clears the workspace state context.
   */
  public function clearContext(): void;

  /**
   * Checks if a workspace state context is currently active.
   *
   * @return bool
   *   TRUE if a context is set, FALSE otherwise.
   */
  public function hasContext(): bool;

  /**
   * Gets the current workspace state context.
   *
   * @return array|null
   *   Array with 'workspace_id' and 'published_timestamp' keys, or NULL if no
   *   context is set.
   */
  public function getContext(): ?array;

}
