<?php

namespace Drupal\wse_parallel;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Service provider for WSE Parallel module.
 */
class WseParallelServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $modules = $container->getParameter('container.modules');

    // Only register parallel edit warning service if navigation_plus is enabled.
    if (isset($modules['navigation_plus'])) {
      $container->register('wse_parallel.parallel_edit_warning_service', ParallelEditWarningService::class)
        ->setArguments([
          new Reference('navigation_plus.ui'),
          new Reference('workspaces.manager'),
          new Reference('workspaces.information'),
          new Reference('wse_parallel.live_revision_resolver'),
          new Reference('wse_parallel.parallel_warning_builder'),
          new Reference('messenger'),
          new Reference('logger.channel.wse_parallel'),
        ]);

      $container->register('wse_parallel.parallel_edit_warning_subscriber', 'Drupal\wse_parallel\EventSubscriber\ParallelEditWarningSubscriber')
        ->setArguments([
          new Reference('wse_parallel.parallel_edit_warning_service'),
        ])
        ->addTag('event_subscriber');
    }
  }

}
