<?php

namespace Drupal\Tests\wse_parallel\Unit;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\wse_parallel\Parallel\SessionTrackerInterface;
use Drupal\wse_parallel\Publish\PublishLookup;
use Drupal\wse_parallel\WseParallel;

/**
 * Tests the WseParallel facade.
 *
 * @coversDefaultClass \Drupal\wse_parallel\WseParallel
 * @group wse_parallel
 */
class WseParallelTest extends UnitTestCase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Mock the container and services.
    $container = $this->createMock('Symfony\Component\DependencyInjection\ContainerInterface');
    
    $sessionTracker = $this->createMock(SessionTrackerInterface::class);
    $publishLookup = $this->createMock(PublishLookup::class);
    $currentUser = $this->createMock(AccountInterface::class);
    $time = $this->createMock('Drupal\Component\Datetime\TimeInterface');
    
    $time->method('getRequestTime')->willReturn(1234567890);
    $currentUser->method('id')->willReturn(1);
    
    $container->method('get')->willReturnMap([
      ['wse_parallel.session_tracker', 1, $sessionTracker],
      ['wse_parallel.publish_lookup', 1, $publishLookup],
      ['current_user', 1, $currentUser],
      ['datetime.time', 1, $time],
    ]);
    
    \Drupal::setContainer($container);
  }

  /**
   * Tests getEntityParallelState returns correct DTO.
   *
   * @covers ::getEntityParallelState
   */
  public function testGetEntityParallelState() {
    $entity = $this->createMockEntity();
    
    $state = WseParallel::getEntityParallelState($entity);
    
    $this->assertInstanceOf(
      'Drupal\wse_parallel\ValueObject\ParallelStateDto',
      $state
    );
  }

  /**
   * Tests markSessionClosedOnPublish calls session tracker.
   *
   * @covers ::markSessionClosedOnPublish
   */
  public function testMarkSessionClosedOnPublish() {
    $entity = $this->createMockEntity();
    $account = $this->createMock(AccountInterface::class);
    
    // This test verifies the method can be called without errors.
    // In a real scenario, we'd mock the session tracker to verify it's called.
    WseParallel::markSessionClosedOnPublish($entity, $account);
    
    $this->assertTrue(TRUE);
  }

  /**
   * Creates a mock entity.
   *
   * @return \Drupal\Core\Entity\ContentEntityInterface
   */
  protected function createMockEntity(): ContentEntityInterface {
    $entity = $this->createMock(ContentEntityInterface::class);
    
    $entityType = $this->createMock(EntityTypeInterface::class);
    $entityType->method('isRevisionable')->willReturn(TRUE);
    
    $entity->method('getEntityType')->willReturn($entityType);
    $entity->method('getEntityTypeId')->willReturn('node');
    $entity->method('id')->willReturn(1);
    $entity->method('getRevisionId')->willReturn(10);
    
    return $entity;
  }

}
