<?php

declare(strict_types=1);

namespace Drupal\wse_task_monitor;

use Drupal\workspaces\WorkspaceInterface;

/**
 * Interface for workspace task monitors.
 *
 * Defines the contract for handlers that monitor and track progress of
 * workspace-related tasks such as backups and publishing operations.
 */
interface WorkspaceTaskMonitorInterface {

  /**
   * Creates a task for this handler type.
   *
   * @param \Drupal\workspaces\WorkspaceInterface $workspace
   *   The workspace entity.
   * @param array $context
   *   Additional context for task creation.
   *
   * @return \Drupal\wse_task_monitor\WorkspaceTask
   *   The created task object.
   */
  public function createTask(WorkspaceInterface $workspace, array $context = []): WorkspaceTask;

  /**
   * Gets the current progress of a task from external sources.
   *
   * @param \Drupal\wse_task_monitor\WorkspaceTask $task
   *   The task to get progress for.
   *
   * @return array|null
   *   Array with 'progress' (0-100) and 'message' keys, or NULL if no external
   *   progress.
   */
  public function getTaskProgress(WorkspaceTask $task): ?array;

  /**
   * Performs cleanup when a task completes.
   *
   * @param \Drupal\wse_task_monitor\WorkspaceTask $task
   *   The completed task.
   */
  public function cleanup(WorkspaceTask $task): void;

}
