<?php

namespace Drupal\wse_config\Entity;

use Drupal\Core\Entity\Attribute\ContentEntityType;
use Drupal\Core\Entity\EditorialContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user\EntityOwnerTrait;
use Drupal\views\EntityViewsData;
use Drupal\wse_config\WseConfigInterface;

/**
 * Defines the 'wse_config' entity class.
 */
#[ContentEntityType(
  id: 'wse_config',
  label: new TranslatableMarkup('Workspace config'),
  label_collection: new TranslatableMarkup('Workspace config'),
  entity_keys: [
    'id' => 'id',
    'revision' => 'revision_id',
    'langcode' => 'langcode',
    'label' => 'name',
    'uuid' => 'uuid',
    'published' => 'status',
    'owner' => 'uid',
  ],
  handlers: [
    'views_data' => EntityViewsData::class,
  ],
  base_table: 'wse_config',
  data_table: 'wse_config_field_data',
  revision_table: 'wse_config_revision',
  revision_data_table: 'wse_config_field_revision',
  translatable: TRUE,
  revision_metadata_keys: [
    'revision_user' => 'revision_user',
    'revision_created' => 'revision_created',
    'revision_log_message' => 'revision_log_message',
  ],
)]
class WseConfig extends EditorialContentEntityBase implements WseConfigInterface {

  use EntityOwnerTrait;

  /**
   * {@inheritdoc}
   */
  public function getCreatedTime() {
    return $this->get('created')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setCreatedTime($timestamp) {
    $this->set('created', $timestamp);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);
    $fields += static::ownerBaseFieldDefinitions($entity_type);

    $fields['uid']
      ->setLabel(t('Author'))
      ->setDescription(t('The user ID of the wse_config author.'))
      ->setRevisionable(TRUE);

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Authored on'))
      ->setTranslatable(TRUE)
      ->setRevisionable(TRUE)
      ->setDescription(t('The time that the wse config was created.'));

    $fields['changed'] = BaseFieldDefinition::create('changed')
      ->setLabel(t('Changed'))
      ->setTranslatable(TRUE)
      ->setRevisionable(TRUE)
      ->setDescription(t('The time that the wse config was last edited.'));

    $fields['name'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Config Name'))
      ->setDescription(t('Name of the config entity.'))
      ->setRequired(TRUE)
      ->setSetting('max_length', 255);

    $fields['collection'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Collection'))
      ->setDescription(t('The collection of the config entity.'))
      ->setRequired(TRUE)
      ->setTranslatable(TRUE)
      ->setRevisionable(TRUE)
      ->setSetting('max_length', 255);

    $fields['data'] = BaseFieldDefinition::create('string_long')
      ->setLabel(t('The raw data of the config entity.'))
      ->setRequired(TRUE)
      ->setRevisionable(TRUE)
      ->setTranslatable(TRUE);

    return $fields;
  }

}
