<?php

declare(strict_types=1);

namespace Drupal\wse_config_test\Hook;

use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\wse_config_test\WseConfigAccessControlHandler;
use Drupal\wse_config_test\WseConfigListBuilder;
use Drupal\wse_config_test\WseConfigViewBuilder;

/**
 * Hook implementations for wse_config_test.
 */
class WseConfigTestEntityHooks {

  /**
   * Implements hook_entity_type_alter().
   */
  #[Hook('entity_type_alter')]
  public function entityTypeAlter(array &$entity_types): void {
    if (!isset($entity_types['wse_config'])) {
      return;
    }

    /** @var \Drupal\Core\Entity\ContentEntityTypeInterface $entity_type */
    $entity_type = $entity_types['wse_config'];

    // Set handlers.
    $entity_type->setAccessClass(WseConfigAccessControlHandler::class);
    $entity_type->setViewBuilderClass(WseConfigViewBuilder::class);
    $entity_type->setListBuilderClass(WseConfigListBuilder::class);
    $entity_type->setFormClass('delete', ContentEntityDeleteForm::class);
    $entity_type->setHandlerClass('route_provider', ['html' => AdminHtmlRouteProvider::class]);

    // Set links.
    $entity_type->setLinkTemplate('canonical', '/wse-config/{wse_config}');
    $entity_type->setLinkTemplate('delete-form', '/admin/config/development/configuration/config-content/{wse_config}/delete');
    $entity_type->setLinkTemplate('collection', '/admin/config/development/configuration/config-content');

    // Enable revision UI.
    $entity_type->set('show_revision_ui', TRUE);

    // Set admin permission.
    $entity_type->set('admin_permission', 'access wse_config overview');
  }

  /**
   * Implements hook_entity_base_field_info_alter().
   */
  #[Hook('entity_base_field_info_alter')]
  public function entityBaseFieldInfoAlter(array &$fields, EntityTypeInterface $entity_type): void {
    if ($entity_type->id() !== 'wse_config') {
      return;
    }

    // Add display options for status field.
    if (isset($fields['status'])) {
      $fields['status']
        ->setDisplayOptions('form', [
          'type' => 'boolean_checkbox',
          'settings' => [
            'display_label' => TRUE,
          ],
          'weight' => 120,
        ])
        ->setDisplayConfigurable('form', TRUE);
    }

    // Add display options for uid field.
    if (isset($fields['uid'])) {
      $fields['uid']
        ->setDisplayOptions('form', [
          'type' => 'entity_reference_autocomplete',
          'settings' => [
            'match_operator' => 'CONTAINS',
            'size' => 60,
            'placeholder' => '',
          ],
          'weight' => 15,
        ])
        ->setDisplayConfigurable('form', TRUE)
        ->setDisplayOptions('view', [
          'label' => 'above',
          'type' => 'author',
          'weight' => 15,
        ])
        ->setDisplayConfigurable('view', TRUE);
    }

    // Add display options for created field.
    if (isset($fields['created'])) {
      $fields['created']
        ->setDisplayOptions('view', [
          'label' => 'above',
          'type' => 'timestamp',
          'weight' => 20,
        ])
        ->setDisplayConfigurable('form', TRUE)
        ->setDisplayOptions('form', [
          'type' => 'datetime_timestamp',
          'weight' => 20,
        ])
        ->setDisplayConfigurable('view', TRUE);
    }
  }

}
