<?php

declare(strict_types=1);

namespace Drupal\wse\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Hook\Attribute\RemoveHook;
use Drupal\Core\State\StateInterface;
use Drupal\workspaces\Hook\WorkspacesHooks;

/**
 * Hook overrides for WSE.
 */
class WseOverrideHooks {

  public function __construct(
    protected WorkspacesHooks $workspacesHooks,
    protected StateInterface $state,
  ) {}

  /**
   * Implements hook_cron().
   */
  #[Hook('cron')]
  #[RemoveHook('cron', class: WorkspacesHooks::class, method: 'cron')]
  public function cron(): void {
    // Ensure that we don't try to clean up revisions for closed workspaces that
    // have been deleted.
    $deleted_workspace_ids = $this->state->get('workspace.deleted', []);
    $deleted_closed_workspace_ids = $this->state->get('wse.deleted_closed', []);
    $deleted_open_workspace_ids = array_diff_key($deleted_workspace_ids, $deleted_closed_workspace_ids);
    if (array_diff_key($deleted_workspace_ids, $deleted_open_workspace_ids)) {
      $this->state->set('workspace.deleted', $deleted_open_workspace_ids);
    }
    if ($deleted_closed_workspace_ids) {
      $this->state->set('wse.deleted_closed', []);
    }

    $this->workspacesHooks->cron();
  }

}
