<?php

namespace Drupal\wse\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Validation constraint for an entity being edited in a closed workspace.
 */
#[Constraint(
  id: 'WseClosedWorkspace',
  label: new TranslatableMarkup('Closed Workspace', [], ['context' => 'Validation']),
  type: ['entity']
)]
class WseClosedWorkspaceConstraint extends SymfonyConstraint {

  /**
   * The default violation message.
   *
   * @var string
   */
  public $message = 'The %label workspace is closed, its content can no longer be edited.';

}
