<?php

namespace Drupal\wse\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Validation constraint for entity types that are not supported by Workspaces.
 */
#[Constraint(
  id: 'WseUnsupportedEntityType',
  label: new TranslatableMarkup('Unsupported Entity Type', [], ['context' => 'Validation']),
  type: ['entity']
)]
class WseUnsupportedEntityTypeConstraint extends SymfonyConstraint {

  /**
   * The default violation message.
   *
   * @var string
   */
  public $message = 'This entity can only be changed in the Live workspace.';

}
