(function (Drupal, once) {
  Drupal.behaviors.wseDiscardEntityModal = {
    attach(context, settings) {
      once(
        'wse-discard-modal',
        'input[name="include_dependencies"]',
        context,
      ).forEach(function (checkbox) {
        // Listen for checkbox changes
        checkbox.addEventListener('change', function () {
          // Trigger a resize event to reposition the dialog vertically
          // when dependencies section is shown/hidden
          window.dispatchEvent(new Event('resize'));
        });
      });
      once(
        'wse-discard-modal-details',
        '#dependencies-wrapper details',
        context,
      ).forEach(function (detail) {
        detail.addEventListener('click', function () {
          // Trigger a resize event on click of the fieldsets.
          window.dispatchEvent(new Event('resize'));
        });
      });
    },
  };
})(Drupal, once);
