<?php

namespace Drupal\wse_config\Cache;

use Drupal\Core\Cache\CacheFactoryInterface;
use Drupal\wse_config\WorkspaceIdResolver;

/**
 * Implements the factory for workspace specific cache backends.
 */
class WseCacheBackendFactory implements CacheFactoryInterface {

  /**
   * The decorated cache backend factory.
   *
   * @var \Drupal\Core\Cache\CacheFactoryInterface
   */
  protected $innerFactory;

  /**
   * The workspace ID resolver.
   */
  protected WorkspaceIdResolver $workspaceIdResolver;

  /**
   * Constructs the DatabaseBackendFactory object.
   *
   * @param \Drupal\Core\Cache\CacheFactoryInterface $inner_factory
   *   The decorated cache backend factory.
   * @param \Drupal\wse_config\WorkspaceIdResolver $workspace_id_resolver
   *   The workspace ID resolver.
   */
  public function __construct(CacheFactoryInterface $inner_factory, WorkspaceIdResolver $workspace_id_resolver) {
    $this->innerFactory = $inner_factory;
    $this->workspaceIdResolver = $workspace_id_resolver;
  }

  /**
   * {@inheritdoc}
   */
  public function get($bin) {
    $allowed_bins = ['config', 'data', 'discovery'];
    if (!in_array($bin, $allowed_bins, TRUE)) {
      return $this->innerFactory->get($bin);
    }

    return new WseCacheBackend(
      $this->innerFactory->get($bin),
      $this->workspaceIdResolver,
    );
  }

}
