<?php

namespace Drupal\wse_config\Cache;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Cache\ChainedFastBackend;
use Drupal\wse_config\WorkspaceIdResolver;

/**
 * Defines a chained fast backend that omits fast caching inside workspaces.
 */
class WseChainedFastBackend extends ChainedFastBackend {

  /**
   * The workspace ID resolver.
   */
  protected WorkspaceIdResolver $workspaceIdResolver;

  /**
   * Constructs a ChainedFastBackend object.
   *
   * @param \Drupal\Core\Cache\CacheBackendInterface $consistent_backend
   *   The consistent cache backend.
   * @param \Drupal\Core\Cache\CacheBackendInterface $fast_backend
   *   The fast cache backend.
   * @param string $bin
   *   The cache bin for which the object is created.
   * @param \Drupal\wse_config\WorkspaceIdResolver $workspace_id_resolver
   *   The workspace ID resolver.
   */
  public function __construct(CacheBackendInterface $consistent_backend, CacheBackendInterface $fast_backend, $bin, WorkspaceIdResolver $workspace_id_resolver) {
    parent::__construct($consistent_backend, $fast_backend, $bin);
    $this->workspaceIdResolver = $workspace_id_resolver;
  }

  /**
   * Gets the last write timestamp.
   */
  protected function getLastWriteTimestamp() {
    if ($this->workspaceIdResolver->getActiveWorkspaceId()) {
      return 0;
    }

    return parent::getLastWriteTimestamp();
  }

}
