<?php

declare(strict_types=1);

namespace Drupal\Tests\wse_config\Functional;

use Drupal\Core\Session\AccountSwitcherInterface;
use Drupal\Core\Session\AnonymousUserSession;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\wse\Functional\WseTestUtilities;

/**
 * Provides a base class for WSE Config browser tests.
 */
abstract class WseConfigTestBase extends BrowserTestBase {

  use WseTestUtilities;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'block',
    'user',
    'workspaces',
    'workspaces_ui',
    'wse',
    'wse_config',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  protected const array ADMIN_PERMISSIONS = [
    'administer workspaces',
    'create workspace',
    'view own workspace',
    'view any workspace',
    'edit own workspace',
    'edit any workspace',
    'delete own workspace',
    'delete any workspace',
    'bypass entity access own workspace',
  ];

  protected const string ANONYMOUS_SESSION = 'anonymous';
  protected const string NON_WORKSPACES_USER = 'non_workspaces_user';
  protected const string WORKSPACES_USER_1 = 'workspaces_user_1';
  protected const string WORKSPACES_USER_2 = 'workspaces_user_2';

  /**
   * An array of user accounts to use in tests, initialized in ::setUp().
   *
   * @var array<string, \Drupal\Core\Session\AccountInterface|false>
   */
  protected array $users = [
    self::ANONYMOUS_SESSION => FALSE,
    self::NON_WORKSPACES_USER => FALSE,
    self::WORKSPACES_USER_1 => FALSE,
    self::WORKSPACES_USER_2 => FALSE,
  ];

  /**
   * The account switcher service.
   */
  protected AccountSwitcherInterface $accountSwitcher;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->accountSwitcher = \Drupal::service('account_switcher');

    // Create users.
    $this->users = [
      self::ANONYMOUS_SESSION => new AnonymousUserSession(),
      self::NON_WORKSPACES_USER => $this->createUser([], self::NON_WORKSPACES_USER),
      // Use permissions constants statically so subclasses can override them.
      self::WORKSPACES_USER_1 => $this->createUser(static::ADMIN_PERMISSIONS, self::WORKSPACES_USER_1),
      self::WORKSPACES_USER_2 => $this->createUser(static::ADMIN_PERMISSIONS, self::WORKSPACES_USER_2),
    ];

    $this->setupWorkspaceSwitcherBlock();

    // Set the front page to something that's valid without the node module
    // and doesn't cause form validation errors on the site configuration form.
    \Drupal::configFactory()
      ->getEditable('system.site')
      ->set('page.front', '/user')
      ->save();
  }

}
