<?php

declare(strict_types=1);

namespace Drupal\wse_preview\EventSubscriber;

use Drupal\workspaces\Event\WorkspaceSwitchEvent;
use Drupal\wse_preview\Negotiator\CookieWorkspaceNegotiator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Removes the workspace preview cookie when switching workspaces.
 */
class WorkspaceSwitchSubscriber implements EventSubscriberInterface {

  public function __construct(
    protected readonly CookieWorkspaceNegotiator $cookieWorkspaceNegotiator,
    protected readonly RequestStack $requestStack,
  ) {}

  /**
   * Removes the preview cookie when switching workspaces.
   *
   * @param \Drupal\workspaces\Event\WorkspaceSwitchEvent $event
   *   The workspace switch event.
   */
  public function onWorkspaceSwitch(WorkspaceSwitchEvent $event): void {
    $request = $this->requestStack->getMainRequest();
    // Forcefully unset the request cookie so that the session negotiator is
    // able to set the active workspace.
    $request->cookies->remove('wse_preview');
    $this->cookieWorkspaceNegotiator->unsetActiveWorkspace();
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      WorkspaceSwitchEvent::class => 'onWorkspaceSwitch',
    ];
  }

}
