<?php

namespace Drupal\xero\Plugin\DataType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\Attribute\DataType;
use Drupal\xero\TypedData\Definition\RepeatingInvoiceDefinition;

/**
 * Describes a Xero repeating invoice.
 *
 * @DataType(
 *   id = "xero_repeating_invoice",
 *   label = @Translation("Xero Repeating Invoice"),
 *   definition_class = "\Drupal\xero\TypedData\Definition\RepeatingInvoiceDefinition",
 *   list_class = "\Drupal\xero\Plugin\DataType\XeroItemList"
 * )
 */
#[DataType(
  id: 'xero_repeating_invoice',
  label: new TranslatableMarkup('Xero Repeating Invoice'),
  definition_class: RepeatingInvoiceDefinition::class,
  list_class: XeroItemList::class,
)]
class RepeatingInvoice extends Invoice {

  /**
   * {@inheritdoc}
   */
  public static $guid_name = "RepeatingInvoiceID";

  /**
   * {@inheritdoc}
   */
  public static $xero_name = 'RepeatingInvoice';

  /**
   * {@inheritdoc}
   */
  public static $plural_name = 'RepeatingInvoices';

  /**
   * {@inheritdoc}
   */
  public static $label = 'RepeatingInvoiceID';

}
