<?php

namespace Drupal\xero\Plugin\DataType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\Attribute\DataType;
use Drupal\xero\TypedData\Definition\BrandingThemeDefinition;

/**
 * Describes a Xero branding theme.
 *
 * @DataType(
 *   id = "xero_branding_theme",
 *   label = @Translation("Xero Branding Theme"),
 *   definition_class = "\Drupal\xero\TypedData\Definition\BrandingThemeDefinition",
 *   list_class = "\Drupal\xero\Plugin\DataType\XeroItemList"
 * )
 */
#[DataType(
  id: 'xero_branding_theme',
  label: new TranslatableMarkup('Xero Branding Theme'),
  definition_class: BrandingThemeDefinition::class,
  list_class: XeroItemList::class,
)]
class BrandingTheme extends XeroComplexItemBase {

  /**
   * {@inheritdoc}
   */
  public static $guid_name = 'BrandingThemeID';

  /**
   * {@inheritdoc}
   */
  public static $xero_name = 'BrandingTheme';

  /**
   * {@inheritdoc}
   */
  public static $plural_name = 'BrandingThemes';

  /**
   * {@inheritdoc}
   */
  public static $label = 'Name';

}
