<?php

namespace Drupal\xero\Plugin\DataType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\Attribute\DataType;
use Drupal\xero\TypedData\Definition\LinkedTransactionDefinition;

/**
 * Describes Xero linked transaction data type.
 *
 * @DataType(
 *   id = "xero_linked_transaction",
 *   label = @Translation("Xero Linked Transaction"),
 *   definition_class = "\Drupal\xero\TypedData\Definition\LinkedTransactionDefinition",
 *   list_class = "\Drupal\xero\Plugin\DataType\XeroItemList"
 * )
 */
#[DataType(
  id: 'xero_linked_transaction',
  label: new TranslatableMarkup('Xero Linked Transaction'),
  definition_class: LinkedTransactionDefinition::class,
  list_class: XeroItemList::class,
)]
class LinkedTransaction extends XeroComplexItemBase {

  /**
   * {@inheritdoc}
   */
  public static $guid_name = 'LinkedTransactionID';

  /**
   * {@inheritdoc}
   */
  public static $xero_name = 'LinkedTtransaction';

  /**
   * {@inheritdoc}
   */
  public static $plural_name = 'LinkedTransactions';

  /**
   * {@inheritdoc}
   */
  public static $label = 'SourceTransactionID';

}
