<?php

/**
 * @file
 * Xero post-updates.
 */

use Drupal\Core\Config\Entity\ConfigEntityUpdater;
use Drupal\Core\Entity\Display\EntityDisplayInterface;

/**
 * Update the 'ignore_case' setting for xero_autocomplete components.
 */
function xero_post_update_autocomplete_ignore_case(&$sandbox) {
  // Use ConfigEntityUpdater to update the entity form display components.
  \Drupal::classResolver(ConfigEntityUpdater::class)->update($sandbox, 'entity_form_display', function (EntityDisplayInterface $display) {
    // Set new value on $display for 'ignore_case' setting.
    foreach ($display->getComponents() as $key => $component) {
      if (isset($component['type']) && $component['type'] === 'xero_autocomplete') {
        if (!isset($component['settings']['ignore_case'])) {
          // If 'ignore_case' setting does not exist, add it with default value.
          $component['settings']['ignore_case'] = FALSE;
        }
        $display->setComponent($key, $component);
        return TRUE;
      }
    }
  });
}
