<?php

namespace Drupal\xls_serialization_extras\Plugin\views\display;

use Drupal\xls_serialization\Plugin\views\display\ExcelExport as OriginalExcelExport;

/**
 * Provides an Excel export display plugin.
 *
 * This overrides the REST Export display to make labeling clearer on the admin
 * UI, and add specific Excel-related functionality.
 *
 * @ingroup views_display_plugins
 *
 * @ViewsDisplay(
 *   id = "excel_export_extras",
 *   title = @Translation("Excel export (Extras)"),
 *   help = @Translation("Export the view results to an Excel file."),
 *   uses_route = TRUE,
 *   admin = @Translation("Excel export (Extras)"),
 *   returns_response = TRUE
 * )
 */
class ExcelExport extends OriginalExcelExport {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['row']['contains']['type']['default'] = 'excel_field';
    return $options;
  }

}
