# Excel Serialization Extras

Sandbox for
the [Excel Serialization](https://www.drupal.org/project/xls_serialization)
module.

This sandbox is used to experiment with new features for
the [Excel Serialization](https://www.drupal.org/project/xls_serialization)
module. The goal is to migrate all successfully user-validated features back to
the original module.

To benefit from the new features of the module, you must use the new View
display and style named **Excel export (Extras)**.

This module **requires**
the [2.1.x-dev](https://www.drupal.org/project/xls_serialization/releases/2.1.x-dev)
version of
the [Excel Serialization](https://www.drupal.org/project/xls_serialization)
module.

**Warning**: this module is highly experimental. Use it cautiously.

## New "extras" features

### Support for cell styling using field formatters

Select the **Excel** field formatter (when available) to set text styles (bold,
italic), column alignment (left, right, center), or to collapse the column.

#### Support for DateTime and Timestamp patterns

Select the **Excel** field formatter to generate real date cells in Excel,
formatted according to the chosen Drupal date format.

#### Support for long numeric values

Select the **Excel** field formatter to force long numeric values to display as
text, avoiding Excel’s default scientific notation formatting.

### Support for styled image insertion

Select the **Excel** field formatter to insert the corresponding styled image
into your Excel spreadsheet.

### Support for formulas with tokens

Add a new **Excel formula** field to your Drupal view and use tokens to
reference other fields or the current row number (`{{ row }}`) in your custom
formula.

### New sheet alter and row processor hooks

Remember to select the new **Excel export (Extras)** view style to enable the
row processor hook.

Check the `xls_serialization_extras.api.php` file for usage examples.
