<?php

namespace Drupal\xls_serialization_extras\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\link\Plugin\Field\FieldFormatter\LinkFormatter;

/**
 * Plugin implementation of the 'excel_link' formatter.
 */
#[FieldFormatter(
  id: 'excel_link',
  label: new TranslatableMarkup('Excel'),
  field_types: [
    'link',
  ]
)]
class ExcelLinkFormatter extends LinkFormatter {

  use ExcelFormatterTrait;

  /**
   * {@inheritDoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $form = parent::settingsForm($form, $form_state);
    unset($form['rel']);
    unset($form['target']);
    return $this->commonSettingsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = parent::viewElements($items, $langcode);
    foreach ($elements as $delta => $element) {
      if ($element['#type'] === 'link') {
        $url = $element['#url'];
        $url->setAbsolute(TRUE);
        $attributes = $element['#attributes'] ?? [];
        $attributes['url'] = $url->toString();
        $elements[$delta] = [
          '#type' => 'excel_data',
          '#data_type' => 'link',
          '#value' => $element['#title'],
          '#attributes' => $attributes,
        ];
      }
    }
    return $elements;
  }

}
