<?php

namespace Drupal\xls_serialization_extras\Render;

use Drupal\Component\Render\MarkupInterface;

/**
 * Defines an object that represents Excel cell data.
 */
interface ExcelDataMarkupInterface extends MarkupInterface {

  /**
   * Returns the Excel value object as an array.
   *
   * @return array
   *   The Excel value array.
   */
  public function toArray(): array;

  /**
   * Sets the value of the Excel value object.
   *
   * @param mixed $value
   *   The value to set for the Excel value object.
   */
  public function setValue(mixed $value): void;

}
