<?php

namespace Drupal\xls_serialization_extras\Plugin\Field\FieldFormatter;

use Drupal\Component\Utility\UrlHelper;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\image\Plugin\Field\FieldFormatter\ImageUrlFormatter;

/**
 * Plugin implementation of the 'excel_image' formatter.
 */
#[FieldFormatter(
  id: 'excel_image',
  label: new TranslatableMarkup('Excel'),
  description: new TranslatableMarkup('Allows to add styling to an Excel image column.'),
  field_types: [
    'image',
  ]
)]
class ExcelImageFormatter extends ImageUrlFormatter {

  use ExcelFormatterTrait;

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = parent::viewElements($items, $langcode);
    foreach ($items as $delta => $item) {
      $element = $elements[$delta];
      $image_path = urldecode(UrlHelper::parse($element['#markup'])['path']);
      $absolute_path = DRUPAL_ROOT . $image_path;
      $elements[$delta] = [
        '#type' => 'excel_data',
        '#data_type' => 'image',
        '#value' => $absolute_path,
      ];
    }
    return $elements;
  }

}
