<?php

namespace Drupal\xls_serialization_extras\Plugin;

/**
 * Trait for Excel fields and formatters.
 */
trait ExcelStylesTrait {

  /**
   * Helps build a settings form for the Excel fields and formatters.
   *
   * @param array $form
   *   The form structure.
   * @param array $settings
   *   The Excel style settings.
   */
  public function buildStylesSettingsForm(array &$form, array $settings) {
    $form['excel_bold'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Excel: Bold'),
      '#default_value' => $settings['excel_bold'],
    ];
    $form['excel_italic'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Excel: Italic'),
      '#default_value' => $settings['excel_italic'],
    ];
    $form['excel_underline'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Excel: Underline'),
      '#default_value' => $settings['excel_underline'],
    ];
    $form['excel_color'] = [
      '#type' => 'color',
      '#title' => $this->t('Excel: Color'),
      '#default_value' => $settings['excel_color'],
    ];
    $form['excel_horizontal_alignment'] = [
      '#type' => 'select',
      '#title' => $this->t('Excel: Horizontal alignment'),
      '#options' => [
        '' => $this->t('None'),
        'left' => $this->t('Left'),
        'center' => $this->t('Center'),
        'right' => $this->t('Right'),
      ],
      '#default_value' => $settings['excel_horizontal_alignment'],
    ];
    $form['excel_collapse'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Excel: Collapse and hide column'),
      '#default_value' => $settings['excel_collapse'],
    ];
  }

}
