<?php

namespace Drupal\xls_serialization_extras\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\xls_serialization_extras\Plugin\ExcelStylesTrait;

/**
 * Trait for the Excel formatters.
 */
trait ExcelFieldTrait {

  use ExcelStylesTrait;

  /**
   * Returns the common settings for the Excel formatter.
   *
   * @return array
   *   An associative array of default settings.
   */
  protected static function commonOptions() {
    return [
      'excel_bold' => ['default' => FALSE],
      'excel_italic' => ['default' => FALSE],
      'excel_underline' => ['default' => FALSE],
      'excel_color' => ['default' => ''],
      'excel_horizontal_alignment' => ['default' => ''],
      'excel_collapse' => ['default' => FALSE],
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    return parent::defineOptions() + static::commonOptions();
  }

  /**
   * Builds the default settings form for the Excel formatter.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  protected function commonOptionsForm(array &$form, FormStateInterface $form_state) {
    $this->buildStylesSettingsForm($form, $this->options);
  }

  /**
   * {@inheritDoc}
   */
  public function buildOptionsForm(array &$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
    $this->commonOptionsForm($form, $form_state);
  }

}
