<?php

namespace Drupal\xls_serialization_extras\Element;

use Drupal\Core\Render\Attribute\RenderElement;
use Drupal\Core\Render\Element\RenderElementBase;
use Drupal\xls_serialization_extras\Render\ExcelDataMarkup;

/**
 * Provides a render element for Excel cell data.
 */
#[RenderElement('excel_data')]
class ExcelData extends RenderElementBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return [
      '#pre_render' => [
        [static::class, 'preRender'],
      ],
    ];
  }

  /**
   * Pre-render callback to generate the Excel markup.
   */
  public static function preRender($element) {
    // Magic trick to ensure Drupal does not replace our custom Excel markup.
    $element['#children'] = static::buildExcelMarkup($element);
    $element['#render_children'] = TRUE;
    return $element;
  }

  /**
   * Builds the Excel markup for the element.
   */
  protected static function buildExcelMarkup($element) {
    $type = $element['#data_type'] ?? 'string';
    $value = $element['#value'] ?? '';
    $attributes = $element['#attributes'] ?? [];
    return ExcelDataMarkup::create($type, $value, $attributes);
  }

}
