<?php

namespace Drupal\xls_serialization_extras\Normalizer;

use Drupal\serialization\Normalizer\NormalizerBase;
use Drupal\xls_serialization_extras\Render\ExcelDataMarkupInterface;

/**
 * Normalizes ExcelMarkupInterface objects into an array.
 */
class ExcelDataMarkupNormalizer extends NormalizerBase {

  /**
   * {@inheritdoc}
   */
  public function normalize($object, $format = NULL, array $context = []): array|string|int|float|bool|\ArrayObject|NULL {
    return $object->toArray();
  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedTypes(?string $format): array {
    return [
      ExcelDataMarkupInterface::class => TRUE,
    ];
  }

}
