<?php

namespace Drupal\xls_serialization_extras\Render;

/**
 * Defines an object that represents Excel cell data.
 *
 * This object should only be constructed with a known safe formula string.
 * If there is any risk that the string contains user-entered data that has not
 * been filtered first, it must not be used.
 *
 * @internal
 *   This object is marked as internal because it should only be used in the
 *   context of Excel data rendering.
 */
final class ExcelDataMarkup implements ExcelDataMarkupInterface {

  /**
   * The data type.
   *
   * @var string
   */
  protected $type;

  /**
   * The data value.
   *
   * @var mixed
   */
  protected $value;

  /**
   * The data attributes.
   *
   * @var mixed
   */
  protected $attributes;

  /**
   * Creates an ExcelValue object if necessary.
   *
   * @param string $type
   *   The data type.
   * @param mixed $value
   *   The data value.
   * @param array $attributes
   *   The data attributes array.
   *
   * @return \Drupal\xls_serialization_extras\Render\ExcelDataMarkupInterface
   *   An Excel value markup object.
   */
  public static function create($type, $value, $attributes = []) {
    $excel_markup = new self();
    $excel_markup->type = $type;
    $excel_markup->value = $value;
    $excel_markup->attributes = $attributes;
    return $excel_markup;
  }

  /**
   * Sets the value of the Excel value object.
   *
   * @param mixed $value
   *   The value to set for the Excel value object.
   */
  public function setValue(mixed $value): void {
    $this->value = $value;
  }

  /**
   * {@inheritDoc}
   */
  public function toArray(): array {
    return [
      'type' => $this->type,
      'value' => $this->value,
      'attributes' => $this->attributes,
    ];
  }

  /**
   * {@inheritDoc}
   */
  public function __toString() {
    return $this->value;
  }

  /**
   * {@inheritDoc}
   */
  public function jsonSerialize(): string {
    return $this->__toString();
  }

}
