<?php

/**
 * @file
 * Hooks provided by the Excel Serialization Extras module.
 */

use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alters Excel object to customize output.
 *
 * @param PhpOffice\PhpSpreadsheet\Worksheet\Worksheet $sheet
 *   The Excel object.
 * @param array $context
 *   Options that normalizers/encoders have access to.
 *
 * @ingroup xls_serialization
 */
function hook_xls_serialization_extras_worksheet_alter(Worksheet $sheet, array $context) {
  $view = $context['views_style_plugin']->view ?? NULL;
  if (!$view) {
    return;
  }

  /** @var \Drupal\views\ViewExecutable $view */
  if ($view->id() === 'your_view_id' && $view->current_display === 'your_display_id') {
    // Set format for column `A` as number.
    $sheet
      ->getStyle('A')
      ->getNumberFormat()
      ->setFormatCode(NumberFormat::FORMAT_NUMBER);

    // Changed horizontal alignment to left for all cells.
    $last_cel = $sheet->getHighestColumn();
    $sheet
      ->getStyle('A:' . $last_cel)
      ->getAlignment()
      ->setHorizontal(Alignment::HORIZONTAL_LEFT);
  }

}

/**
 * Provides a row processor for Excel exports.
 *
 * This hook allows you to process each row of the view result before it is
 * serialized.
 *
 * @param \Drupal\views\ViewExecutable $view
 *   The view executable object.
 */
function hook_xls_serialization_extras_view_row_processor(\Drupal\views\ViewExecutable $view) {
  if ($view->id() === 'my_view') {
    return function (&$row, \Drupal\views\ResultRow $result, \Drupal\views\ViewExecutable $view) {
      // Do something with $row, e.g., modify, collect stats, tag, etc.
    };
  }
  return NULL;
}

/**
 * @} End of "addtogroup hooks".
 */
