<?php

namespace Drupal\xls_serialization_extras\Plugin\Field\FieldFormatter;

use Drupal\Core\Datetime\Entity\DateFormat;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\datetime\Plugin\Field\FieldFormatter\DateTimeDefaultFormatter;

/**
 * Plugin implementation of the 'excel_datetime' formatter.
 */
#[FieldFormatter(
  id: 'excel_datetime',
  label: new TranslatableMarkup('Excel'),
  description: new TranslatableMarkup('Allows to add styling to an Excel date/time column.'),
  field_types: [
    'datetime',
  ]
)]
class ExcelDateTimeFormatter extends DateTimeDefaultFormatter {

  use ExcelFormatterTrait;

  /**
   * {@inheritdoc}
   */
  public function prepareView(array $entities_items) {
    parent::prepareView($entities_items);
    $format_name = $this->getSetting('format_type');
    $date_format = DateFormat::load($format_name);
    if ($date_format) {
      $excel_pattern = ExcelFormatterUtils::phpToExcelDatePattern($date_format->getPattern());
      $this->setSetting('excel_pattern', $excel_pattern);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = parent::viewElements($items, $langcode);
    $excel_pattern = $this->getSetting('excel_pattern');
    foreach ($items as $delta => $item) {
      $element = $elements[$delta];
      $attributes = $element['#attributes'];
      if ($excel_pattern) {
        $attributes['pattern'] = $excel_pattern;
      }
      $elements[$delta] = [
        '#type' => 'excel_data',
        '#data_type' => 'datetime',
        '#value' => $element['#text'],
        '#attributes' => $attributes,
      ];
    }
    return $elements;
  }

}
