<?php

namespace Drupal\xls_serialization_extras\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\xls_serialization_extras\Plugin\ExcelStylesTrait;

/**
 * Trait for the Excel formatters.
 */
trait ExcelFieldTrait {

  use ExcelStylesTrait;

  /**
   * Returns the common settings for the Excel formatter.
   *
   * @return array
   *   An associative array of default settings.
   */
  protected static function commonOptions() {
    return [
      'excel_bold' => ['default' => FALSE],
      'excel_italic' => ['default' => FALSE],
      'excel_underline' => ['default' => FALSE],
      'excel_color' => ['default' => ''],
      'excel_horizontal_alignment' => ['default' => ''],
      'excel_collapse' => ['default' => FALSE],
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    return parent::defineOptions() + static::commonOptions();
  }

  /**
   * Builds the default settings form for the Excel formatter.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  protected function commonOptionsForm(array &$form, FormStateInterface $form_state) {
    $this->buildStylesSettingsForm($form, $this->options);
  }

  /**
   * {@inheritDoc}
   */
  public function buildOptionsForm(array &$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
    $this->commonOptionsForm($form, $form_state);
  }

  /**
   * Unsets the style settings from the form.
   *
   * @param array $form
   *   The form array to modify.
   */
  protected function unsetStyleSettings(&$form) {
    unset($form['style_settings']);
    unset($form['element_type_enable']);
    unset($form['element_type']);
    unset($form['element_class_enable']);
    unset($form['element_class']);
    unset($form['element_label_type_enable']);
    unset($form['element_label_type']);
    unset($form['element_label_class_enable']);
    unset($form['element_label_class']);
    unset($form['element_wrapper_type_enable']);
    unset($form['element_wrapper_type']);
    unset($form['element_wrapper_class_enable']);
    unset($form['element_wrapper_class']);
    unset($form['element_default_classes']);
  }

  /**
   * Unsets the empty field behavior settings from the form.
   *
   * @param array $form
   *   The form array to modify.
   */
  protected function unsetEmptyFieldBehavior(&$form) {
    unset($form['empty_field_behavior']);
    unset($form['empty']);
    unset($form['empty_zero']);
    unset($form['hide_empty']);
    unset($form['hide_alter_empty']);
  }

}
