<?php

namespace Drupal\xls_serialization_extras\Plugin\views\row;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\rest\Plugin\views\row\DataFieldRow;
use Drupal\views\Attribute\ViewsRow;
use Drupal\xls_serialization_extras\Render\ExcelDataMarkupInterface;

/**
 * Plugin which displays fields as raw data for Excel.
 *
 * @ingroup views_row_plugins
 */
#[ViewsRow(
  id: "excel_field",
  title: new TranslatableMarkup("Fields Excel"),
  help: new TranslatableMarkup("Use fields as row data for Excel."),
  display_types: ["data"]
)]
class ExcelFieldRow extends DataFieldRow {

  /**
   * {@inheritdoc}
   */
  public function render($row) {
    $output = [];

    foreach ($this->view->field as $id => $field) {
      // If the raw output option has been set, just get the raw value.
      if (!empty($this->rawOutputOptions[$id])) {
        $value = $field->getValue($row);
      }
      // Otherwise, get rendered field.
      else {
        // Advanced render for token replacement.
        $markup = $field->advancedRender($row);
        // We want to keep the original ExcelDataMarkup instance around.
        // It will later be converted to an array by our custom normalizer.
        if ($field->original_value instanceof ExcelDataMarkupInterface) {
          $excel_data_markup = $field->original_value;
          $excel_data_markup->setValue((string) $markup);
          $markup = $excel_data_markup;
        }
        // Post render to support uncacheable fields.
        $field->postRender($row, $markup);
        $value = $field->last_render;
      }

      // Omit excluded fields from the rendered output.
      if (empty($field->options['exclude'])) {
        $output[$this->getFieldKeyAlias($id)] = $value;
      }
    }

    return $output;
  }

}
