<?php

namespace Drupal\xnavigation\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for the xNavigation module.
 */
class XnavigationHooks {

  /**
   * Implements hook_page_attachments().
   */
  #[Hook('page_attachments')]
  public function pageAttachments(array &$attachments): void {
    // Get the colour scheme setting.
    $config = \Drupal::config('xnavigation.settings');
    $color_scheme = $config->get('color_scheme') ?? 'blackstone';

    // Only attach if user has the right permission.
    if (\Drupal::currentUser()->hasPermission('access navigation bar')) {
      // Inline JS to set colour class immediately.
      $attachments['#attached']['html_head'][] = [
        [
          '#tag' => 'script',
          '#attributes' => ['type' => 'text/javascript'],
          '#value' => "document.documentElement.classList.add('xnavigation-{$color_scheme}');",
        ],
        'xnavigation_color_scheme',
      ];

      // Attach CSS/JS for the chosen scheme.
      $attachments['#attached']['library'][] = "xnavigation/xnavigation.{$color_scheme}";

      // Attach the generic xnavigation library.
      $attachments['#attached']['library'][] = 'xnavigation/xnavigation';
    }
  }

}
