<?php

namespace Drupal\xNavigation\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configures xNavigation settings.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'xnavigation_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['xnavigation.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('xnavigation.settings');

    // Add a dropdown for Color Scheme
    $form['color_scheme'] = [
      '#type' => 'select',
      '#title' => $this->t('Color scheme'),
      '#options' => [
        'blackstone' => $this->t('Blackstone'),
        'core' => $this->t('Core'),
        'night' => $this->t('Night (low contrast)'),
        'pahoe' => $this->t('Pahoe'),
        'slate' => $this->t('Slate'),
      ],
      '#default_value' => $config->get('color_scheme') ?? 'blackstone', // Default value
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $this->config('xnavigation.settings')
      ->set('color_scheme', $form_state->getValue('color_scheme'))
      ->save();

    // Clear all caches to apply the new color scheme.
    \Drupal::service('cache.render')->invalidateAll(); // Clears the render cache.
    \Drupal::service('cache.page')->invalidateAll();   // Clears the page cache.

    \Drupal::service('theme.registry')->reset();
  }
}
