/**
 * @file
 * Xray Audit Table Filter.
 */
((Drupal, once) => {
  'use strict';

  Drupal.behaviors.xrayAuditTableFilter = {
    attach: (context) => {
      once('xrayAuditTableFilter', 'input[data-xa-filter-table-target]', context).forEach((input) => {
        input.addEventListener('input', (event) => {
          const targetSelector = input.getAttribute('data-xa-filter-table-target');
          const table = document.getElementById(targetSelector);
          const filterText = event.target.value.toLowerCase();
          const columnsToFilter = JSON.parse(input.getAttribute('data-xa-filter-table-columns-indexes'));

          if (Boolean(table)) {
            const rows = table.querySelectorAll('tbody tr');
            rows.forEach((row) => {
                const cells = row.querySelectorAll('td');
                let rowText;

                if (Boolean(columnsToFilter) && columnsToFilter.length > 0) {
                  rowText = columnsToFilter.map(index => cells[index]?.textContent.toLowerCase() || '').join(' ');
                } else {
                  rowText = Array.from(cells).map(cell => cell.textContent.toLowerCase()).join(' ');
                }
                row.style.display = rowText.includes(filterText) ? '' : 'none';
            });
          }
        });
      });
    }
  };

})(Drupal, once);
