<?php

namespace Drupal\Tests\xray_audit\Kernel;

use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\node\Entity\NodeType;
use Drupal\KernelTests\KernelTestBase;

/**
 * Base class for Xray Audit kernel tests.
 *
 * Provides common functionality for kernel tests including module installation,
 * entity setup, and shared configuration.
 *
 * @codingStandardsIgnoreFile
 */
abstract class XrayAuditKernelTestBase extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'field',
    'filter',
    'text',
    'node',
    'xray_audit',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Install necessary schemas.
    $this->installEntitySchema('user');
    $this->installEntitySchema('node');
    $this->installConfig(['system', 'field', 'node', 'user']);

    // Additional common setup can go here.
  }

  /**
   * {@inheritdoc}
   */
  protected function tearDown(): void {
    parent::tearDown();
    // Common cleanup for all kernel tests can go here.
  }

  /**
   * Creates a test content type.
   *
   * @param string $type_id
   *   The content type machine name.
   * @param string $label
   *   The content type label.
   *
   * @return \Drupal\node\Entity\NodeType
   *   The created content type.
   */
  protected function createContentType(string $type_id, ?string $label = NULL): NodeType {
    $type = NodeType::create([
      'type' => $type_id,
      'name' => $label ?? $type_id,
      'new_revision' => TRUE,
    ]);
    $type->save();
    return $type;
  }

  /**
   * Creates a test field on an entity type.
   *
   * @param string $field_name
   *   The field name.
   * @param string $entity_type
   *   The entity type ID.
   * @param string $bundle
   *   The bundle.
   * @param string $field_type
   *   The field type.
   * @param array $storage_settings
   *   Optional field storage settings.
   * @param array $field_settings
   *   Optional field instance settings.
   */
  protected function createTestField(
    string $field_name,
    string $entity_type,
    string $bundle,
    string $field_type,
    array $storage_settings = [],
    array $field_settings = [],
  ): void {
    // Create field storage.
    $field_storage = FieldStorageConfig::create([
      'field_name' => $field_name,
      'entity_type' => $entity_type,
      'type' => $field_type,
      'settings' => $storage_settings,
    ]);
    $field_storage->save();

    // Create field instance.
    $field = FieldConfig::create([
      'field_storage' => $field_storage,
      'bundle' => $bundle,
      'label' => $field_name,
      'settings' => $field_settings,
    ]);
    $field->save();
  }

}
