<?php

namespace Drupal\Tests\xray_audit\Unit;

use PHPUnit\Framework\MockObject\MockObject;
use Drupal\Tests\UnitTestCase;

/**
 * Base class for Xray Audit unit tests.
 *
 * Provides common functionality for unit tests including mock helpers
 * and shared setup/teardown operations.
 *
 * @codingStandardsIgnoreFile
 */
abstract class XrayAuditUnitTestBase extends UnitTestCase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    // Common setup for all unit tests can go here.
  }

  /**
   * {@inheritdoc}
   */
  protected function tearDown(): void {
    parent::tearDown();
    // Common cleanup for all unit tests can go here.
  }

  /**
   * Creates a mock service with common configuration.
   *
   * @param string $class
   *   The class or interface to mock.
   * @param array $methods
   *   Optional array of methods to mock.
   *
   * @return \PHPUnit\Framework\MockObject\MockObject
   *   The mock object.
   */
  protected function createMockService(string $class, array $methods = []): MockObject {
    if (empty($methods)) {
      return $this->createMock($class);
    }
    return $this->getMockBuilder($class)
      ->onlyMethods($methods)
      ->disableOriginalConstructor()
      ->getMock();
  }

  /**
   * Creates a configured mock that returns specific values.
   *
   * @param string $class
   *   The class or interface to mock.
   * @param array $return_map
   *   Array mapping method names to return values.
   *
   * @return \PHPUnit\Framework\MockObject\MockObject
   *   The configured mock object.
   */
  protected function createMockWithReturnMap(string $class, array $return_map): MockObject {
    $mock = $this->createMock($class);
    foreach ($return_map as $method => $return_value) {
      $mock->method($method)->willReturn($return_value);
    }
    return $mock;
  }

}
