<?php

namespace Drupal\xray_audit\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines Groups attribute object.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class XrayAuditGroupPlugin extends Plugin {

  /**
   * Constructs an XrayAuditGroupPlugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable name of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description of the plugin.
   * @param int $sort
   *   The position of the group in the group list.
   * @param class-string|null $deriver
   *   The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup|string|null $label = NULL,
    public readonly TranslatableMarkup|string|null $description = NULL,
    public readonly int $sort = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}
