<?php

namespace Drupal\xray_audit\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\xray_audit\Services\PluginRepositoryInterface;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * Plugin repository.
   *
   * @var \Drupal\xray_audit\Services\PluginRepositoryInterface
   */
  protected $pluginRepository;

  /**
   * Constructs a new RouteSubscriber object.
   *
   * @param \Drupal\xray_audit\Services\PluginRepositoryInterface $plugin_repository
   *   Plugin repository.
   */
  public function __construct(PluginRepositoryInterface $plugin_repository) {
    $this->pluginRepository = $plugin_repository;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    $this->setPluginGroupRoutes($collection);
    $this->setPluginTaskRoutes($collection);
  }

  /**
   * Sets the plugin task routes.
   *
   * @param \Symfony\Component\Routing\RouteCollection $collection
   *   The route collection.
   */
  protected function setPluginTaskRoutes(RouteCollection $collection) {
    $routing_information = $this->pluginRepository->getAllPluginTaskRouteInfo();
    foreach ($routing_information as $task_route_info) {
      foreach ($task_route_info as $task_route_operation) {
        $collection->add(
          $task_route_operation['route_name'] ?? '',
          new Route(
            $task_route_operation['url'] ?? '',
            [
              '_controller' => '\Drupal\xray_audit\Controller\XrayAuditTaskController::build',
              '_title_callback' => '\Drupal\xray_audit\Controller\XrayAuditTaskController::getTitle',
              'task_operation' => $task_route_operation['operation_id'],
              'task_plugin_id' => $task_route_operation['task_plugin_id'] ?? '',
            ],
            [
              '_permission' => 'xray_audit access',
              '_xray_audit_operation_access' => 'TRUE',
            ]
          )
        );
      }
    }
  }

  /**
   * Sets the plugin group routes.
   *
   * @param \Symfony\Component\Routing\RouteCollection $collection
   *   The route collection.
   */
  protected function setPluginGroupRoutes(RouteCollection $collection) {
    $routing_information = $this->pluginRepository->getAllPluginGroupRouteInfo();
    foreach ($routing_information as $group_route_info) {
      /** @var \Drupal\Core\StringTranslation\TranslatableMarkup $title */
      $collection->add(
        $group_route_info['route_name'] ?? '',
        new Route(
          $group_route_info['url'] ?? '',
          [
            '_controller' => '\Drupal\xray_audit\Controller\XrayAuditGroupsController::build',
            '_title_callback' => '\Drupal\xray_audit\Controller\XrayAuditGroupsController::getGroupTitle',
            'group_id' => $group_route_info['id'],
          ],
          ['_permission' => 'xray_audit access']
        )
      );
    }
  }

}
