<?php

namespace Drupal\Tests\xray_audit\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Base class for Xray Audit functional tests.
 *
 * Provides common functionality for browser tests including user creation,
 * permission setup, and navigation helpers.
 *
 * @codingStandardsIgnoreFile
 */
abstract class XrayAuditBrowserTestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'field',
    'text',
    'filter',
    'user',
    'system',
    'xray_audit',
  ];

  /**
   * A user with administrative permissions.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create an admin user with Xray Audit permissions.
    $this->adminUser = $this->drupalCreateUser([
      'administer site configuration',
      'access xray audit',
      'administer xray audit',
    ]);

    // Additional common setup can go here.
  }

  /**
   * {@inheritdoc}
   */
  protected function tearDown(): void {
    parent::tearDown();
    // Common cleanup for all functional tests can go here.
  }

  /**
   * Navigates to the Xray Audit overview page.
   */
  protected function navigateToXrayAuditOverview(): void {
    $this->drupalGet('/admin/reports/xray-audit');
  }

  /**
   * Navigates to a specific Xray Audit report page.
   *
   * @param string $group_id
   *   The group plugin ID.
   * @param string $task_id
   *   Optional task plugin ID.
   */
  protected function navigateToXrayAuditReport(string $group_id, ?string $task_id = NULL): void {
    $path = '/admin/reports/xray-audit/' . $group_id;
    if ($task_id) {
      $path .= '/' . $task_id;
    }
    $this->drupalGet($path);
  }

  /**
   * Asserts that a report table contains expected data.
   *
   * @param string $expected_text
   *   The text to find in the table.
   */
  protected function assertReportContains(string $expected_text): void {
    $this->assertSession()->pageTextContains($expected_text);
  }

  /**
   * Asserts that CSV export link is present.
   */
  protected function assertCsvExportLinkExists(): void {
    $this->assertSession()->linkExists('Export CSV');
  }

}
