/**
 * @file
 * Provides filtering functionality for the Image Styles Summary table.
 */

(function (Drupal, once) {
  'use strict';

  /**
   * Filter Image Styles Summary table by Result column.
   */
  Drupal.behaviors.imageStylesSummaryFilter = {
    attach: function (context) {
      // Find the filter select element.
      const filterSelect = once('image-styles-filter', '.image-styles-result-filter', context);

      filterSelect.forEach(function (select) {
        // Find the table (it should be a sibling or nearby element).
        const container = select.closest('.image-styles-summary-filter').parentElement;
        const table = container.querySelector('table');

        if (!table) {
          return;
        }

        // Get the Result column index (last column).
        const headers = table.querySelectorAll('thead th');
        let resultColumnIndex = -1;

        headers.forEach((header, index) => {
          if (header.textContent.trim() === 'Result') {
            resultColumnIndex = index;
          }
        });

        if (resultColumnIndex === -1) {
          return;
        }

        // Add change event listener.
        select.addEventListener('change', function () {
          const filterValue = this.value;
          const rows = table.querySelectorAll('tbody tr');

          rows.forEach(function (row) {
            const cells = row.querySelectorAll('td');
            if (cells.length > resultColumnIndex) {
              const resultCell = cells[resultColumnIndex];
              const resultText = resultCell.textContent.trim();

              // Determine if row should be visible.
              let visible = true;

              if (filterValue === 'yes') {
                visible = resultText === 'Yes';
              } else if (filterValue === 'no') {
                visible = resultText === 'No';
              }
              // 'all' means show everything.

              // Show or hide the row.
              if (visible) {
                row.style.display = '';
              } else {
                row.style.display = 'none';
              }
            }
          });
        });
      });
    }
  };

})(Drupal, once);
