<?php

namespace Drupal\xray_audit\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines XrayAudit Tasks attribute object.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class XrayAuditTaskPlugin extends Plugin {

  /**
   * Constructs an XrayAuditTaskPlugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param string $group
   *   The Group that this task belongs to.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable label of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description of the plugin.
   * @param int $sort
   *   The position in the list of the group.
   * @param array $operations
   *   The operation methods.
   * @param array $batches
   *   Method names of batch processes.
   * @param string|null $install
   *   Name of the method that will be launched on module install.
   * @param string|null $uninstall
   *   Name of the method that will be launched on module uninstall.
   * @param int $local_task
   *   If the different operations will show as local task.
   * @param array|null $dependencies
   *   Module dependencies.
   * @param class-string|null $deriver
   *   The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly string $group,
    public readonly TranslatableMarkup|string|null $label = NULL,
    public readonly TranslatableMarkup|string|null $description = NULL,
    public readonly int $sort = 0,
    public readonly array $operations = [],
    public readonly array $batches = [],
    public readonly ?string $install = NULL,
    public readonly ?string $uninstall = NULL,
    public readonly int $local_task = 0,
    public readonly ?array $dependencies = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

}
