<?php

namespace Drupal\yayb;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Defines the YAYB alert service.
 *
 * @todo Make an interface for this!
 */
class YaybService {

  /**
   * Stores the module configuration info.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  private $settings;

  /**
   * Class constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The Config Factory service.
   * @param \Drupal\Component\Datetime\TimeInterface $time
   *   The Time service.
   */
  public function __construct(
    private readonly ConfigFactoryInterface $configFactory,
    private readonly TimeInterface $time,
  ) {
    $this->settings = $configFactory->get('yayb.settings');
  }

  /**
   * Displays the block contents.
   */
  public function view(): ?array {
    if ($this->checkVisibility()) {
      $block = [];
      if ($subject = $this->settings->get('yayb_title')) {
        $block['subject'] = ['#plain_text' => $subject];
      }
      if ($content = $this->settings->get('yayb_message')) {
        $block['content'] = [
          '#type' => 'processed_text',
          '#text' => $content,
          '#format' => $this->settings->get('yayb_filter'),
        ];
      }
      $block['severity'] = $this->settings->get('yayb_severity');
      return $block;
    }
    return NULL;
  }

  /**
   * Check block visibility.
   *
   * @return bool
   *   Returns TRUE if the block should be shown.
   */
  public function checkVisibility(): bool {
    if (!$this->settings->get('yayb_toggle')) {
      return FALSE;
    }
    if (empty($this->settings->get('yayb_expiration'))) {
      return TRUE;
    }
    return strtotime((string) $this->settings->get('yayb_expiration')) > $this->time->getRequestTime();
  }

}
