<?php

/**
 * @author YooMoney <cms@yoomoney.ru>
 * @copyright © 2025 "YooMoney", NBСO LLC
 * @license  https://yoomoney.ru/doc.xml?id=527052
 */

namespace Drupal\yookassa\Helpers;

use Drupal\Core\StringTranslation\StringTranslationTrait;

class YooKassaTaxRateEnumHelper
{
    use StringTranslationTrait;

    public const WITHOUT_VAT = 1;
    public const VAT_0 = 2;
    public const VAT_10 = 3;
    public const VAT_20 = 4;
    public const VAT_110 = 5;
    public const VAT_120 = 6;
    public const VAT_5 = 7;
    public const VAT_7 = 8;
    public const VAT_105 = 9;
    public const VAT_107 = 10;

    /**
     * Возвращает массив с налоговой ставкой для отображения на сайте
     *
     * @return array
     */
    public function getTaxRate(): array
    {
        return [
            self::WITHOUT_VAT => $this->t('Without VAT'),
            self::VAT_0 => $this->t('0%'),
            self::VAT_5 => $this->t('5%'),
            self::VAT_7 => $this->t('7%'),
            self::VAT_10 => $this->t('10%'),
            self::VAT_20 => $this->t('20%'),
            self::VAT_105 => $this->t('Applicable rate 5/105'),
            self::VAT_107 => $this->t('Applicable rate 7/107'),
            self::VAT_110 => $this->t('Applicable rate 10/110'),
            self::VAT_120 => $this->t('Applicable rate 20/120'),
        ];
    }
}
