<?php

use YooKassa\Client;

/**
 * Фабрика для получения единственного статического экземпляра клиента API Юkassa
 */
class YooMoneyClientFactory
{
    const YOOMONEY_SHOP_ID = 'yoomoney_api_shop_id';
    const YOOMONEY_SHOP_PASSWORD = 'yoomoney_api_secret';
    const YOOMONEY_ACCESS_TOKEN_KEY = 'yoomoney_api_access_token';

    const CMS_NAME = 'drupal';
    const MODULE_NAME = 'yoomoney-cms-drupal7';

    /**
     * @var Client
     */
    private static $client;

    /**
     * Возвращает единственный инстанс клиента API Юkassa
     *
     * @return Client
     * @throws Exception
     */
    public static function getYooKassaClient()
    {
        if (!self::$client) {
            self::$client = self::getClient();
        }

        return self::$client;
    }

    /**
     * Возвращает объект клиента API Юkassa
     *
     * @return Client
     * @throws Exception
     */
    private static function getClient()
    {
        $apiClient = new Client();

        $oauthToken = variable_get(self::YOOMONEY_ACCESS_TOKEN_KEY);

        if ($oauthToken) {
            $apiClient->setAuthToken($oauthToken);
            self::setApiClientData($apiClient);

            return $apiClient;
        }

        $shopId = variable_get(self::YOOMONEY_SHOP_ID);
        $password = variable_get(self::YOOMONEY_SHOP_PASSWORD);

        $apiClient->setAuth($shopId, $password);

        self::setApiClientData($apiClient);

        return $apiClient;
    }

    /**
     * Устанавливает значение свойств для user-agent
     *
     * @param $apiClient
     * @return void
     */
    private static function setApiClientData($apiClient)
    {
        $userAgent = $apiClient->getApiClient()->getUserAgent();
        $userAgent->setCms(self::CMS_NAME, VERSION);
        $userAgent->setModule(self::MODULE_NAME, YOOMONEY_MODULE_VERSION);
        $apiClient->setLogger(new YooMoneyLogger());
    }
}