jQuery(document).ready(function ($) {
    const connectBlock = $('.oauth-tab');
    const testField = $('.field_oauth.test');
    const shopIdField = $('.field_oauth.shop-id');
    const fiscalizationField = $('.field_oauth.fiscalization');
    const buttonOauthConnect = $('button.btn_oauth_connect');
    const hiddenShopId = $('#edit-yoomoney-api-shop-id');
    /**
     * Событие на кнопки Подключить магазин и Сменить магазин
     */
    buttonOauthConnect.click(function (e) {
        e.preventDefault();
        changeButton(true);
        fetchOauthLink();
    })

    /**
     * Запрос на бэк для получения ссылки на авторизацию в OAuth
     */
    function fetchOauthLink() {
        $.ajax({
            type: "GET",
            url: Drupal.settings.basePath + 'yoomoney_api/get_oauth_url',
            success: function (response) {
                if (response.oauth_url != null) {
                    showOauthWindow(response.oauth_url);
                } else {
                    addErrorBlock();
                }
            },
            error: function (response) {
                addErrorBlock();
                console.error(response.status, response.statusText);
            }
        });
    }

    /**
     * Добавляет блок с ошибкой
     */
    function addErrorBlock() {
        const errorBlock = '<div class="oauth-error">' + Drupal.t('Something went wrong. Refresh the page and try again.') + '</div>'
        connectBlock.append(errorBlock);
    }

    /**
     * Показ окна с авторизацией в OAuth
     * @param url - Ссылка в OAuth
     */
    function showOauthWindow(url) {
        const oauthWindow = window.open(
            url,
            'Авторизация',
            'width=600,height=600, top=' + ((screen.height - 600) / 2) + ', left=' + ((screen.width - 600) / 2 + window.screenLeft) + ', menubar=no, toolbar=no, location=no, resizable=yes, scrollbars=no, status=yes');

        const timer = setInterval(function () {
            if (oauthWindow.closed) {
                if (oauthWindow.closed) {
                    clearInterval(timer);
                    getOauthToken();
                }
            }
        }, 1000);
    }

    /**
     * Инициализация получения OAuth токена
     */
    function getOauthToken() {
        $.ajax({
            type: "GET",
            url: Drupal.settings.basePath + 'yoomoney_api/get_oauth_token',
            success: function (response) {
                if (response.status == null && response.error) {
                    addErrorBlock();
                    console.error(response);
                }
                if (response.error == null) {
                    location.reload();
                }
            },
            error: function (response) {
                addErrorBlock();
                console.error(response.status, response.statusText);
            }
        });
    }

    /**
     * Меняет значения полей после успешного получения данных
     * @param response
     */
    function changeField(response) {
        if (response.shopId != null) {
            hiddenShopId.val(response.shopId);
            testField.text(response.test ? Drupal.t('Test store') : Drupal.t('Real store'));
            fiscalizationField.text(response.fiscalization ? Drupal.t('Fiscalization enabled') : Drupal.t('Fiscalization disabled'));
            shopIdField.text('Shop ID: ' + response.shopId);
        }
    }

    /**
     * Меняет состояние и текст кнопки
     * @param isDisabled
     * @param text
     * @param spinner
     */
    function changeButton(isDisabled, text = null, spinner = true) {
        buttonOauthConnect.attr('disabled', isDisabled);
        buttonOauthConnect.html(spinner === true ? '<span class="spinner qa-spinner"></span>' : text);
    }
});